<?php
namespace App\Http\Controllers\Agent;

use App\Http\Controllers\Controller;

class RateCalculatorController extends Controller
{
    // Multi-day package calculation
    // $vehicleRate: associative array with 'daily_basic_rate', 'extra_km_rate', 'included_km_per_day'
    public function calculateMultiDay(array $vehicleRate, int $days, int $approxKm)
    {
        $daily = (float)$vehicleRate['daily_basic_rate'];
        $included = isset($vehicleRate['included_km_per_day']) ? (int)$vehicleRate['included_km_per_day'] : 100;
        $extraRate = (float)$vehicleRate['extra_km_rate'];

        $includedTotal = $included * $days;
        $extraKm = max(0, $approxKm - $includedTotal);

        $dailyTotal = $daily * $days;
        $extraTotal = $extraKm * $extraRate;
        $total = $dailyTotal + $extraTotal;

        return [
            'daily_total' => $dailyTotal,
            'extra_km' => $extraKm,
            'extra_total' => $extraTotal,
            'total' => $total
        ];
    }

    // One-way transfer calculation
    // $transferRate: array with 'base_rate', 'base_km', 'extra_km_rate'
    public function calculateOneWay(array $transferRate, int $distance)
    {
        $base = (float)$transferRate['base_rate'];
        $baseKm = (int)$transferRate['base_km'];
        $extraRate = (float)$transferRate['extra_km_rate'];

        if ($distance <= $baseKm) {
            $extraKm = 0;
            $extraTotal = 0;
            $total = $base;
        } else {
            $extraKm = $distance - $baseKm;
            $extraTotal = $extraKm * $extraRate;
            $total = $base + $extraTotal;
        }

        return [
            'base' => $base,
            'extra_km' => $extraKm,
            'extra_total' => $extraTotal,
            'total' => $total
        ];
    }
}
